//EX.4 Program Title:Design zener shunt regulator with variable load for given specification///
////////environment: Scilab 5.5.2
//Tested on OS: Windows 7 Professional, 64 bit
//Book: Electronics Devices and Circuit Theory  by Robert Boylestead and Nashelsky
/////////////////////////////////////////
clc;
clear all;
close;
//////////////////////////////////////////////////////////////////
disp('For desiging Variable Load voltage regulator Circuit :' );
Vi=input('Enter the Input Voltage in volts                          Vi:');//Note:Press enter/// input voltage must be greater than dc regulated voltage////
Vz=input('Enter the required regulated DC output Voltage in volts   Vz:');//Note:Press enter
Izm=input('Enter the value of Maxi. zener current in miliamperes    Izm:');//Note:Press enter/
R=input('Enter the value of Series Resistance in kilo ohms          R:');//Note:Press enter/
disp('According to given Circuit data:' );
Izm1=Izm*1e-3     //miliampere   Maximum Zener Current
R1=R*1e3         // Kilo ohms  Input Resistance 
mprintf('\n Zener Voltage                        Vz:%1fv',Vz);
mprintf('\n Maximum Zener Current                Izm:%2fA',Izm1);
mprintf('\n Input Resistance                     R:%4dohms',R1);
mprintf('\n Input voltage                        Vi:%2dV',Vi);
mprintf('\n');
//////////////Calculate Value of Minimum RL///////////////////////////////////////////
mprintf('\n. \******************Solution*************************************\');
RL_min=(R1*Vz)/(Vi-Vz);  //ohms min load resistance 
mprintf('\n 1)Minimum Load Resistance                   RL_min:%2dohms',RL_min);
//////////////Calculate Value of Minimum Load Current//////////////////////////////////
mprintf('\n. \***************************************************************\');
VR=Vi-Vz;     // volts voltage across input resistance
mprintf('\n 2)Voltage Across R is                       VR=%2dV',VR);
IR=VR/R1;    // mili amperes Current trhough input resistance
IR=IR*1e3;  //amperes
mprintf('\n. \***************************************************************\');
mprintf('\n 3)Current through Input Reistance R is      IR:%.4fmA',IR);
IL_min=(IR*1e-3)-Izm1;   // mili amperes mini. load current 
//IL_min=IL_min*10e3;
mprintf('\n. \****************************************************************\');
mprintf('\n 4)Minimum Load Current                      IL_min=%.3fA',IL_min);
mprintf('\n. \*****************************************************************\');
///////////Calculate Value of Maximum Load Resistance/////////////////////////////
RL_max=Vz/(IL_min);  // ohms maxi. load resistance
//RL_max=RL_min*1e-3;
mprintf('\n 5)Maximum Load Resistance                   RL_max:%dohms',RL_max);
mprintf('\n. \*****************************************************************\');


//output//   
// For desiging Variable Load voltage regulator Circuit :   
//Enter the Input Voltage in volts                          Vi:50
//Enter the required regulated DC output Voltage in volts   Vz:10
//Enter the value of Maxi. zener current in miliamperes    Izm:32
//Enter the value of Series Resistance in kilo ohms          R:1
 
// According to given Circuit data:   

// Zener Voltage                        Vz:10.000000v
// Maximum Zener Current                Izm:0.032000A
// Input Resistance                     R:1000ohms
// Input voltage                        Vi:50V

//. ******************Solution*************************************
// 1)Minimum Load Resistance                   RL_min:250ohms
//. ***************************************************************
// 2)Voltage Across R is                       VR=40V
//. ***************************************************************
//3)Current through Input Reistance R is      IR:40.0000mA
//. ****************************************************************
// 4)Minimum Load Current                      IL_min=0.008A
//. *****************************************************************
// 5)Maximum Load Resistance                   RL_max:1250ohms
//. ***************************************************************** 
